<?php
$suffix = "?s1=" . ($_GET["s1"] ?? "") . "&s2=" . ($_GET["s2"] ?? "") . "&s3=" . ($_GET["s3"] ?? "") . "&s4=" . ($_GET["s4"] ?? "");

if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
	$ip = $_SERVER['HTTP_CLIENT_IP'];
} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
	$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
} else {
	$ip = $_SERVER['REMOTE_ADDR'];
}

$url = "https://pro.ip-api.com/json/" . $ip . "?key=uDBlDLE4QL19zpt";
$body = file_get_contents($url);
$geodata = json_decode($body);
$region = $geodata->region;
$regionName = $geodata->regionName;
?>



<!DOCTYPE html>
<html lang="en">

<head>
	<!-- CUSTOM HEADER -->
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<script data-domain="<?= $_SERVER['HTTP_HOST'] ?>" src="https://plausible.io/js/script.tagged-events.js"></script>
	<!-- CUSTOM CSS -->
	<style>
		body {
			font-family: 'Inter', sans-serif;
			margin: 0;
			padding: 0;
			background: #f8fafc;
			color: #334155;
			line-height: 1.6;
			unicode-bidi: normal;
		}

		.header-bar {
			background: #dc2626;
			color: white;
			text-align: center;
			padding: 12px;
			font-weight: 600;
			font-size: 14px;
		}

		.contentcontainer {
			max-width: 800px;
			margin: 0 auto;
			padding: 20px;
		}

		.asseen {
			display: flex;
			justify-content: center;
			align-items: center;
			gap: 25px;
			margin: 15px 0;
			padding: 15px;
			background: white;
			border-radius: 8px;
			box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
			flex-wrap: wrap;
		}

		.asseen span {
			color: #333;
			font-size: 11px;
			text-transform: uppercase;
			letter-spacing: 2px;
			font-weight: 800;
		}

		.asseen img {
			height: 25px;
			opacity: 0.85;
		}


		.hero {
			background: white;
			border-radius: 12px;
			padding: 30px;
			margin: 20px 0;
			box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
			text-align: center;
		}

		.geo {
			display: none;
			background: #ecfdf5;
			border: 1px solid #059669;
			border-radius: 8px;
			padding: 15px;
			margin: 20px 0;
			text-align: center;
			font-weight: 500;
			font-size: 17px;
		}

		.states {
			color: #059669;
			font-weight: 800;
		}

		.headline {
			font-size: 32px;
			font-weight: 800;
			color: #1e3a8a;
			line-height: 1.2;
			margin-bottom: 20px;
		}

		.subhead {
			font-size: 20px;
			color: #64748b;
			margin-bottom: 30px;
		}

		.status {
			background: #f0f9ff;
			border: 2px solid #0284c7;
			border-radius: 8px;
			padding: 15px;
			text-align: center;
			margin: 20px 0;
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 15px;
			flex-wrap: nowrap;
		}

		.statusindicator {
			display: inline-block;
			min-width: 10px;
			width: 10px;
			min-height: 10px;
			height: 10px;
			background: #16a34a;
			border-radius: 50%;
			animation: pulse 2s infinite;
			flex-shrink: 0;
		}

		@keyframes pulse {
			0% {
				transform: scale(0.95);
				box-shadow: 0 0 0 0 rgba(22, 163, 74, 0.7);
			}

			70% {
				transform: scale(1);
				box-shadow: 0 0 0 10px rgba(22, 163, 74, 0);
			}

			100% {
				transform: scale(0.95);
				box-shadow: 0 0 0 0 rgba(22, 163, 74, 0);
			}
		}

		.contentbox {
			background: white;
			border-radius: 12px;
			padding: 25px;
			margin: 20px 0;
			box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
		}

		.highlight {
			background: #f0f9ff;
			border-left: 4px solid #0284c7;
			padding: 20px;
			margin: 20px 0;
		}

		.bullets {
			background: #f8fafc;
			padding: 20px;
			border-radius: 8px;
			margin: 20px 0;
		}

		.bullets ul {
			list-style: none;
			padding: 0;
			margin: 0;
		}

		.ctabutton {
			display: block;
			background: #16a34a;
			color: white;
			text-decoration: none;
			padding: 20px 30px;
			border-radius: 8px;
			font-size: 20px;
			font-weight: 600;
			text-align: center;
			margin: 30px 0;
			transition: transform 0.2s;
		}

		.ctabutton:hover {
			transform: translateY(-2px);
			background: #15803d;
		}

		.bullets li {
			margin-bottom: 15px;
			padding-left: 25px;
			position: relative;
		}

		.bullets li::before {
			content: "✓";
			color: #16a34a;
			position: absolute;
			left: 0;
			font-weight: bold;
		}

		.testimonial {
			font-style: italic;
			border-left: 4px solid #e2e8f0;
			padding-left: 20px;
			margin: 20px 0;
		}

		.stars {
			color: #fbbf24;
			font-size: 18px;
			margin-bottom: 8px;
		}

		.reviewer {
			color: #64748b;
			font-weight: 600;
			font-style: normal;
			margin-top: 8px;
			display: block;
		}

		footer {
			text-align: center;
			padding: 20px;
			font-size: 12px;
			color: #64748b;
		}
	</style>
	<!-- END CUSTOM CSS -->

</head>

<body>
	<div class="header-bar">
		⚠️ WARNING: This Program Expires Soon - Limited Spots Available in Your Area
	</div>

	<div class="contentcontainer">
		<div class="asseen ">
			<span>As seen in:</span>
			<img src="https://d31otfhas71ais.cloudfront.net/cms-assets/images/6797b095be43b1f0110e2bc3/6797b180d9781c243a0a0815.png">
			<img src="https://d31otfhas71ais.cloudfront.net/cms-assets/images/6797b095be43b1f0110e2bc3/6797b180d9781c243a0a0814.png">
			<img src="https://d31otfhas71ais.cloudfront.net/cms-assets/images/6797b095be43b1f0110e2bc3/6797b180d9781c243a0a0813.png">
			<img src="https://d31otfhas71ais.cloudfront.net/cms-assets/images/6797b095be43b1f0110e2bc3/6797b17fd9781c243a0a0812.png">
		</div>

		<div class="hero">
			<div class="geo" style="display: block;">
				<span style="color: #059669; font-size: 20px;">✓</span>
				<span class="program-status">Program Available in</span>
				<span class="states"><?php echo $regionName; ?></span>!
			</div>

			<div class="headline">
				American Homeowners Are Using This "Homeowner Relief Program" To Get Up To $500K Cash In 2025
			</div>
			<div class="subhead">
				New program is helping thousands of homeowners get up to $500K cash to help with living costs - See if you qualify now
			</div>
			<div class="status">
				<span class="statusindicator"></span>
				<strong>Program Status: ACCEPTING NEW APPLICANTS</strong>
			</div>
			<mini-quiz data-questions='[{"question":"Are you an American homeowner?","type":"button","options":[{"option":"Yes","desired":false},{"option":"No","desired":true}]},{"question":"How old are you?","type":"select","options":[{"option":"18","desired":true},{"option":"19","desired":true},{"option":"20","desired":true},{"option":"21","desired":true},{"option":"22","desired":true},{"option":"23","desired":true},{"option":"24","desired":true},{"option":"25","desired":true},{"option":"26","desired":true},{"option":"27","desired":true},{"option":"28","desired":true},{"option":"29","desired":true},{"option":"30","desired":true},{"option":"31","desired":true},{"option":"32","desired":true},{"option":"33","desired":true},{"option":"34","desired":true},{"option":"35","desired":true},{"option":"36","desired":true},{"option":"37","desired":true},{"option":"38","desired":true},{"option":"39","desired":true},{"option":"40","desired":true},{"option":"41","desired":true},{"option":"42","desired":true},{"option":"43","desired":true},{"option":"44","desired":true},{"option":"45","desired":true},{"option":"46","desired":true},{"option":"47","desired":true},{"option":"48","desired":true},{"option":"49","desired":true},{"option":"50","desired":true},{"option":"51","desired":true},{"option":"52","desired":true},{"option":"53","desired":true},{"option":"54","desired":true},{"option":"55","desired":true},{"option":"56","desired":true},{"option":"57","desired":true},{"option":"58","desired":true},{"option":"59","desired":true},{"option":"60","desired":true},{"option":"61","desired":true},{"option":"62","desired":true},{"option":"63","desired":true},{"option":"64","desired":true},{"option":"65","desired":true},{"option":"66","desired":true},{"option":"67","desired":true},{"option":"68","desired":true},{"option":"69","desired":true},{"option":"70","desired":true},{"option":"71","desired":true},{"option":"72","desired":true},{"option":"73","desired":true},{"option":"74","desired":true},{"option":"75","desired":true},{"option":"76","desired":true},{"option":"77","desired":true},{"option":"78","desired":true},{"option":"79","desired":true},{"option":"80","desired":true},{"option":"81","desired":true},{"option":"82","desired":true},{"option":"83","desired":true},{"option":"84","desired":true},{"option":"85","desired":true},{"option":"86","desired":true},{"option":"87","desired":true},{"option":"88","desired":true},{"option":"89","desired":true},{"option":"90","desired":true},{"option":"91","desired":true},{"option":"92","desired":true},{"option":"93","desired":true},{"option":"94","desired":true},{"option":"95","desired":true},{"option":"96","desired":true},{"option":"97","desired":true},{"option":"98","desired":true},{"option":"99","desired":true},{"option":"100","desired":true}]},{"question":"What state do you live in?","type":"select","options":[{"option":"Alabama","desired":true},{"option":"Alaska","desired":true},{"option":"Arizona","desired":true},{"option":"Arkansas","desired":true},{"option":"California","desired":true},{"option":"Colorado","desired":true},{"option":"Connecticut","desired":true},{"option":"Delaware","desired":true},{"option":"Florida","desired":true},{"option":"Georgia","desired":true},{"option":"Hawaii","desired":true},{"option":"Idaho","desired":true},{"option":"Illinois","desired":true},{"option":"Indiana","desired":true},{"option":"Iowa","desired":true},{"option":"Kansas","desired":true},{"option":"Kentucky","desired":true},{"option":"Louisiana","desired":true},{"option":"Maine","desired":true},{"option":"Maryland","desired":true},{"option":"Massachusetts","desired":true},{"option":"Michigan","desired":true},{"option":"Minnesota","desired":true},{"option":"Mississippi","desired":true},{"option":"Missouri","desired":true},{"option":"Montana","desired":true},{"option":"Nebraska","desired":true},{"option":"Nevada","desired":true},{"option":"New Hampshire","desired":true},{"option":"New Jersey","desired":true},{"option":"New Mexico","desired":true},{"option":"New York","desired":true},{"option":"North Carolina","desired":true},{"option":"North Dakota","desired":true},{"option":"Ohio","desired":true},{"option":"Oklahoma","desired":true},{"option":"Oregon","desired":true},{"option":"Pennsylvania","desired":true},{"option":"Rhode Island","desired":true},{"option":"South Carolina","desired":true},{"option":"South Dakota","desired":true},{"option":"Tennessee","desired":true},{"option":"Texas","desired":true},{"option":"Utah","desired":true},{"option":"Vermont","desired":true},{"option":"Virginia","desired":true},{"option":"Washington","desired":true},{"option":"West Virginia","desired":true},{"option":"Wisconsin","desired":true},{"option":"Wyoming","desired":true}]}]' data-conditions='{"Do you have $25,000 or more in credit card debt?":"No","How old are you?":["18","19","20","21","22","23","24","25","26","27","28","29","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95","96","97","98","99","100"],"What state do you live in?":["Alabama","Alaska","Arizona","Arkansas","California","Colorado","Connecticut","Delaware","Florida","Georgia","Hawaii","Idaho","Illinois","Indiana","Iowa","Kansas","Kentucky","Louisiana","Maine","Maryland","Massachusetts","Michigan","Minnesota","Mississippi","Missouri","Montana","Nebraska","Nevada","New Hampshire","New Jersey","New Mexico","New York","North Carolina","North Dakota","Ohio","Oklahoma","Oregon","Pennsylvania","Rhode Island","South Carolina","South Dakota","Tennessee","Texas","Utah","Vermont","Virginia","Washington","West Virginia","Wisconsin","Wyoming"]}' data-positive-result='<div class="formcontentinner">
<span class="qualify1">Congratulations!</span>
<p class="qualify">You&apos;re eligible for this homeowner benefit! Tap below and answer a few more questions to complete registration and see how much you could qualify for.</p>
<p><b>How Much Money Are You Looking For?</b></p>
<p class="yesqualify"><a href="/homeowner-invest-program/offer.php<?php echo $suffix; ?>" target="_blank" > Over $10,000  >></a></p>
</div>' data-negative-result='<div class="formcontentinner">
<p class="qualify"> <span class="qualify1">Congratulations!</span>
<p class="qualify">You&apos;re eligible for this benefit! Tap below and answer a few more questions to complete registration.</p>
<p><b>How Long Have You Owned Your Home?</b></p>
<p class="qualify"><a href="/homeowner-invest-program/offer.php<?php echo $suffix; ?>" target="_blank">Less Than 5 Years >></a></p>
<p class="qualify"><a href="/homeowner-invest-program/offer.php<?php echo $suffix; ?>" target="_blank">More Than 5 Years >></a></p>

</div>'></mini-quiz>

		</div>

		<div class="contentbox">
			<h2>Here's What You Need to Know...</h2>
			<p>If you're an American homeowner who could use some extra financial help, this might be the most important message you read today.</p>

			<div class="highlight">
				<p><strong>FACT:</strong> Americans who act now receiving an average of $175,000 for being a homeowner.</p>
			</div>

			<p>Thanks to recent regulations, homeowners are now able to receive relief with living expenses like never before. This means...</p>

			<div class="bullets">
				<ul>
					<li>Receive up to $500,000 in cash for being a homeowner</li>
					<li>No monthly payments or interest to pay back</li>
					<li>No need to sell your home or get any type of loan</li>
					<li>Use relief funds to pay for living expenses, bills, vacations & more</li>
				</ul>
			</div>

			<a href="/homeowner-invest-program/offer.php<?php echo $suffix; ?>" class="ctabutton">
				CHECK IF YOU QUALIFY NOW →
			</a>

			<div class="testimonial">
				<div class="stars">★★★★★</div>
				"I was drowning in $320,000 of debt. This program helped me get my hands on enough cash to pay off all my debts. I still can't believe it."
				<span class="reviewer">- Michael S.</span>
			</div>

			<div class="testimonial">
				<div class="stars">★★★★★</div>
				"After years of struggling and not know what to do, I finally found real help. They were able to get me $147,000 since I owned my own home. My only regret is not finding this program sooner!"
				<span class="reviewer">- Jennifer R.</span>
			</div>

			<div class="testimonial">
				<div class="stars">★★★★★</div>
				"The relief was immediate. Within days I was able to get funds to completely change my life. Now I can finally sleep at night knowing I'm on the path to being debt-free and able to survive."
				<span class="reviewer">- David M.</span>
			</div>
		</div>

		<div class="contentbox">
			<h2>Why This Works So Well</h2>
			<p>As you know, home prices have skyrocketed over the years and valuations are still very high. As a result, there are trillions of dollars tied up in real estate that you are able to access quickly.</p>

			<div class="bullets">
				<ul>
					<li>Home prices are higher than ever</li>
					<li>If you've owned your home for more than 2 years you can qualify</li>
					<li>Inflation and living expenses are taking a toll on Americans</li>
				</ul>
			</div>

			<div class="highlight">
				<p><strong>WARNING:</strong> Due to high demand, spots in this program are limited. Check your eligibility now before someone else takes your spot.</p>
			</div>

			<a href="/homeowner-invest-program/offer.php<?php echo $suffix; ?>" class="ctabutton">
				SEE HOW MUCH YOU CAN GET →
			</a>
		</div>
	</div>


	<footer>
		<!-- <p><a href="/privacy.php">Privacy Policy</a> • <a href="/terms.php">Terms of Use</a> • <a href="/about-us.php">About Us</a></p> -->
	</footer>

	<script src="https://unpkg.com/react@17/umd/react.production.min.js" crossorigin></script>
	<script src="https://unpkg.com/react-dom@17/umd/react-dom.production.min.js" crossorigin></script>
	<script src="https://unpkg.com/@babel/standalone/babel.min.js"></script>
	<style>
		.quiz-container {
			background: #FFFFFF;
			box-shadow: 0px 2px 4px rgba(10, 37, 64, 0.25);
			border-radius: 13px;
			max-width: 100%;
			padding: 23px 16px 28px 16px;
			margin: 20px auto;
			font-family: Arial, Helvetica, sans-serif;
			transition: height 0.5s ease, min-height 0.5s ease;
			overflow: hidden;
			min-height: 250px;
		}

		.quiz-progress-bar-wrapper {
			display: flex;
			align-items: center;
			gap: 10px;
		}

		.quiz-progress-bar {
			flex-grow: 1;
			background-color: rgba(13, 51, 76, 0.25);
			border-radius: 5px;
			height: 11px;
			position: relative;
		}

		.quiz-progress {
			height: 10px;
			background-color: rgb(51, 51, 51);
			border-radius: 5px;
			transition: width 0.3s ease;
		}

		.quiz-progress-percent {
			font-size: 14px;
			font-family: 'Open Sans', sans-serif;
			color: #333;
			font-weight: 700;
		}

		.quiz-processing-image {
			display: block;
			margin: auto;
			opacity: 1;
			transition: opacity 1s ease-in-out;
		}

		.quiz-processing-image.fade-out {
			opacity: 0;
		}

		.quiz-fade {
			transition: opacity 0.5s ease-in-out;
			opacity: 0;
		}

		.quiz-fade.active {
			opacity: 1;
		}

		.quiz-result-fade {
			opacity: 0;
			transition: opacity 1s ease-in-out;
			font-size: 22px;
		}

		.quiz-result-fade.active {
			opacity: 1;
		}

		.quiz-warning {
			color: red;
			text-align: center;
		}

		.quiz-container h3 {
			text-align: center;
			font-size: 25px;
			font-weight: 700;
			margin: 20px 0;
		}

		.quiz-button,
		.quiz-select-next {
			text-align: center;
			height: 48px;
			width: 100%;
			max-width: 420px;
			margin: 10px auto;
			display: block;
			background: #db9e1d;
			color: #ffffff;
			font-size: 24px;
			line-height: 145%;
			border-radius: 6px;
			padding: 6px 26px;
			outline: none;
			border: none;
			cursor: pointer;
		}

		.quiz-select {
			background-image: url(https://d31otfhas71ais.cloudfront.net/cms-assets/images/672cfa1a47a13fdbb1081ab3/672e45a45db1cbb1b20a4522.svg);
			background-repeat: no-repeat;
			background-position: right 0.75rem center;
			padding: 14px 15px;
			width: 100%;
			box-sizing: border-box;
			color: #2C3E50;
			font-size: 16px;
			background-color: #F6F9FC;
			text-transform: capitalize;
			border: 1px solid #697386;
			border-radius: 4px;
			appearance: none;
			background-size: 12px;
			margin-bottom: 23px;
			max-width: 420px;
			margin-left: auto;
			margin-right: auto;
			display: block;
		}

		.quiz-result-text {
			font-size: 22px;
			font-weight: 600;
			padding-top: 30px;
			line-height: 1.7;
			margin-bottom: 22px;
		}
	</style>

	<script type="text/babel">
		function parseQuizzes() {
			const quizTags = document.querySelectorAll("mini-quiz");
			return Array.from(quizTags).map(function (quiz, index) {
				let quizData = {};

				quizData.id = index;
				quizData.element = quiz;
				quizData.questions = JSON.parse(quiz.getAttribute("data-questions"));
				quizData.conditions = JSON.parse(quiz.getAttribute("data-conditions"));
				quizData.positiveResult = quiz.getAttribute("data-positive-result");
				quizData.negativeResult = quiz.getAttribute("data-negative-result");

				return quizData;
			});
		}

		function MiniQuiz(props) {
			const quizData = props.quizData;
			const [currentQuestion, setCurrentQuestion] = React.useState(0);
			const [answers, setAnswers] = React.useState({});
			const [showResult, setShowResult] = React.useState(false);
			const [fade, setFade] = React.useState(true);
			const [processing, setProcessing] = React.useState(false);
			const [processingDone, setProcessingDone] = React.useState(false);
			const [warning, setWarning] = React.useState("");
			const stepNumber = currentQuestion + 1; 

			function handleAnswer(field, answer) {
				if (window.plausible) {
					window.plausible(`step-${stepNumber}`);
				}
				
				let newAnswers = Object.assign({}, answers);
				newAnswers[field] = answer;
				setAnswers(newAnswers);
				setFade(false);
				setTimeout(function () {
					if (currentQuestion < quizData.questions.length - 1) {
						setCurrentQuestion(currentQuestion + 1);
						setFade(true);
					} else {
						setProcessing(true);
						setShowResult(false);
						setProcessingDone(false);
						setTimeout(function () {
							setProcessing(false);
							setProcessingDone(true);
							setTimeout(function () {
								setShowResult(true);
							}, 500);
						}, 3000);
					}
				}, 500);
			}

			function handleNextSelect(field) {
				const selectElement = document.getElementById("select-" + quizData.id);
				let selectedValue = "";
				if (selectElement) {
					selectedValue = selectElement.value;
				}
				if (selectedValue !== "") {
					setWarning("");
					handleAnswer(field, selectedValue);
				} else {
					setWarning("Please select an option before proceeding.");
				}
			}

			function calculateProgress() {
				return (Object.keys(answers).length / quizData.questions.length) * 100;
			}

			function evaluateResult() {
				const conditions = quizData.conditions;
				for (let field in conditions) {
					const conditionValue = conditions[field];
					const userAnswer = answers[field];

					if (Array.isArray(conditionValue)) {
						if (!conditionValue.includes(userAnswer)) {
							return quizData.negativeResult;
						}
					} else if (userAnswer !== conditionValue) {
						return quizData.negativeResult;
					}
				}
				return quizData.positiveResult;
			}

			let content;

			if (processing) {
				content = React.createElement("img", {
					src: "https://d31otfhas71ais.cloudfront.net/cms-assets/images/63fd21080086ab09d00439d2/quiz_processing.gif",
					alt: "Processing...",
					className: "quiz-processing-image " + (processingDone ? "fade-out" : "")
				});
			} else if (showResult) {
				content = React.createElement("div", {
					className: "quiz-result-fade " + (showResult ? "active" : ""),
					dangerouslySetInnerHTML: { __html: evaluateResult() }
				});
			} else {
				let questionContent;
				if (quizData.questions[currentQuestion].type === "button") {
					questionContent = quizData.questions[currentQuestion].options.map(function (option) {
						return React.createElement("button", {
							key: option.option,
							className: "quiz-button",
							onClick: function () {
								handleAnswer(quizData.questions[currentQuestion].question, option.option);
							}
						}, option.option);
					});
				} else {
					questionContent = React.createElement("div", {}, [
						React.createElement("select", {
							id: "select-" + quizData.id,
							className: "quiz-select",
							defaultValue: ""
						}, [
							React.createElement("option", { value: "", disabled: true }, "Select an option")
						].concat(
							quizData.questions[currentQuestion].options.map(function (option) {
								return React.createElement("option", { key: option.option, value: option.option }, option.option);
							})
						)),
						React.createElement("button", {
							className: "quiz-select-next",
							onClick: function () {
								handleNextSelect(quizData.questions[currentQuestion].question);
							}
						}, "Next"),
						warning ? React.createElement("div", { className: "quiz-warning" }, warning) : null
					]);
				}

				content = React.createElement("div", { className: "quiz-fade " + (fade ? "active" : "") }, [
					React.createElement("h3", {}, quizData.questions[currentQuestion].question),
					questionContent
				]);
			}

			return React.createElement("div", { className: "quiz-container" }, [
				React.createElement("div", { className: "quiz-progress-bar-wrapper" }, [
					React.createElement("div", { className: "quiz-progress-bar" }, [
						React.createElement("div", {
							className: "quiz-progress",
							style: { width: calculateProgress() + "%" }
						})
					]),
					React.createElement("span", { className: "quiz-progress-percent" }, Math.round(calculateProgress()) + "%")
				]),
				React.createElement("hr"),
				content
			]);
		}

		function initializeQuizzes() {
			const quizzes = parseQuizzes();
			quizzes.forEach(function (quizData) {
				ReactDOM.render(React.createElement(MiniQuiz, { quizData: quizData }), quizData.element);
			});
		}

		initializeQuizzes();
	</script>


	<style>
		.formcontentinner {
			padding-bottom: 23px;
			max-width: 420px;
			width: 100%;
			margin: 0 auto;
			text-align: center;
			position: relative;
		}

		.quiz-button,
		.quiz-select-next {
			background: #16a34a;
		}

		.quiz-button:hover,
		.quiz-select-next:hover {
			background: #15803d;
		}

		.redBtn:hover {
			background: #c18c1a;
		}

		.qualify1 {
			font-size: 30px;
			font-weight: 600;
			padding-top: 30px;
		}

		.qualify {
			font-size: 22px;
			font-weight: 600;
			padding-top: 30px;
		}

		.yesqualify {
			font-size: 22px;
			font-weight: 600;
		}

		@media screen and (max-width: 700px) {
			.qualify1 {
				font-size: 25px;
			}

			.qualify {
				font-size: 20px;
				padding-top: 0px;
			}

			.yesqualify {
				font-size: 17px;
			}
		}
	</style>



	<!-- IMPRESSION-PIXELS -->

	<!-- END IMPRESSION-PIXELS -->


</body>

</html>