<?php

$urls = [
    [
        "url" => "https://www.unlksite.com/XG3WN4/SL1HB/",
        "sub_id" => "sub"
    ],
    [
        "url" => "https://www.unlksite.com/XG3WN4/SL1HB/",
        "sub_id" => "sub"
    ]
];

$rnd = rand(0, count($urls) - 1); // Randomly select a URL
$selected = $urls[$rnd];
$url = $selected["url"];
$sub_id = $selected["sub_id"];

// Build the suffix from request parameters (always "s1", "s2", "s3")
$suffix = "";
foreach (["1", "2", "3"] as $paramIndex) {
    $requestParamName = "s" . $paramIndex; // Parameters from the request are always "s1", "s2", "s3"
    $finalParamName = $sub_id . $paramIndex; // Use sub_id as prefix for the final URL
    if (!empty($_GET[$requestParamName])) {
        $suffix .= "&{$finalParamName}=" . urlencode($_GET[$requestParamName]);
    }
}

// Preserve the fbclid if it exists in the query parameters
if (!empty($_GET['fbclid'])) {
    $suffix .= "&fbclid=" . urlencode($_GET['fbclid']);
}

// Append the suffix correctly based on whether the URL already has query parameters
if (strpos($url, '?') !== false) {
    // URL already has query parameters, append using '&'
    $finalUrl = $url . $suffix;
} else {
    // URL has no query parameters, start with '?'
    $finalUrl = $url . '?' . ltrim($suffix, '&');
}

header("Location: " . $finalUrl);
exit;
